/*:
 * @plugindesc タイトルからnewGameを削除するだけのプラグイン
 * @author にゃたま
 *
 * @help タイトルからnewGameを削除する機能を追加します。
 */
(function() {
    var parameters      = PluginManager.parameters('TitlenewGameDelete');
    //=============================================================================
    // Window_TitleCommand
    //  タイトルのコンティニュー削除を追加定義します。
    //=============================================================================
    var _Window_TitleCommand_makeCommandList      = Window_TitleCommand.prototype.makeCommandList;
    Window_TitleCommand.prototype.makeCommandList = function() {
        _Window_TitleCommand_makeCommandList.call(this);
       
        this.eraseCommandnewGame();
    };

    Window_TitleCommand.prototype.eraseCommandnewGame = function() {
        this._list = this._list.filter(function(command) {
            return command.symbol !== 'newGame';
        })
    };
})();